import { StyleSheet } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { I18nManager } from "react-native";

let singleItemWidth = (dpr("wf") - dpr(40)) / 3;

export const filtersStyles = StyleSheet.create({
    selectCont: {
        marginTop: dpr(20),
        paddingBottom: dpr(15),
    },
    subSelectCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
    },
    selectBrandContainer: {
        flex: 1,
        flexDirection: 'row',
        flexWrap: 'wrap',
    },
    selectText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
    },
    priceRange: {
        fontSize: dpr(18),
        marginTop: dpr(20),
    },
    inputCont: {
        flexDirection: "row",
        paddingBottom: dpr(15),
    },
    inputGroup: {
        width: (dpr("wf") - dpr(65)) / 2,
        marginTop: dpr(15),
    },
    inputText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(13),
        color: "#898989",
    },
    input: {
        borderBottomWidth: 1,
        borderBottomColor: "#898989",
        textAlign: I18nManager.isRTL ? "right" : "left",
    },
    ratingCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        marginVertical: dpr(15),
    },
    selececolorCont1: {
        flexDirection: "row",
        alignItems: "center",
        marginBottom: dpr(20),
        width: singleItemWidth,
    },
    colorText: (isChecked) => ({
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: isChecked ? '#2C2C2C' : '#898989',
        marginLeft: dpr(10),
        width: singleItemWidth - dpr(40),
        textAlign: 'left'
    }),
    keyboardAvoidingFlex: {
        flex: 1,
    },
    backNavigation: {
        flexDirection: 'row',
        alignItems: 'center',
        backgroundColor: "#FFFFFF",
        paddingTop: dpr(15),
        paddingBottom: dpr(5),
        minHeight: dpr(64),
        paddingHorizontal: dpr(20)
    },
    iconWrap: {
        paddingLeft: dpr(20),
        height: dpr(30),
        width: dpr(60),
        zIndex: 9999,
        backgroundColor: "rgba(255, 255, 255,0.5)",
    },
    title: {
        flex: 1,
        textAlign:'center',
        fontSize: dpr(20),
        fontFamily: "DMSans_700Bold",
        color: "#2C2C2C",
        paddingHorizontal: dpr(10),
    }
});
